-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Jul 11, 2025 at 08:40 AM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `school`
--

-- --------------------------------------------------------

--
-- Table structure for table `admins`
--

CREATE TABLE `admins` (
  `id` int(11) NOT NULL,
  `admin_id` varchar(20) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `gender` enum('male','female','other','prefer-not-to-say') NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('super_admin','admin','moderator') NOT NULL DEFAULT 'admin',
  `verification_code` varchar(64) DEFAULT NULL,
  `verification_code_expiry` datetime DEFAULT NULL,
  `is_verified` tinyint(1) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `last_login` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `admins`
--

INSERT INTO `admins` (`id`, `admin_id`, `full_name`, `email`, `phone`, `gender`, `password`, `role`, `verification_code`, `verification_code_expiry`, `is_verified`, `is_active`, `last_login`, `created_at`, `updated_at`) VALUES
(7, 'ADMC8B8CF2A', 'SEUN', 'olorodemicheal2274@gmail.com', '09028622243', 'female', '$2y$10$obx6BhMNcr4MqhBR.74fyOGBejS1/O0gzPDhSIiTsp3c5f6jWuRyO', 'admin', NULL, NULL, 1, 1, '2025-07-10 11:35:17', '2025-07-04 20:55:53', '2025-07-10 11:35:17');

-- --------------------------------------------------------

--
-- Table structure for table `admin_login_history`
--

CREATE TABLE `admin_login_history` (
  `id` int(11) NOT NULL,
  `admin_id` int(11) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `device_info` text NOT NULL,
  `login_time` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `admin_login_history`
--

INSERT INTO `admin_login_history` (`id`, `admin_id`, `ip_address`, `device_info`, `login_time`) VALUES
(1, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-04 22:02:00'),
(2, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-04 22:04:58'),
(3, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-05 08:21:51'),
(4, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-05 08:55:03'),
(5, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-05 09:38:20'),
(6, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-05 14:50:52'),
(7, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-06 18:33:35'),
(8, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-06 19:12:50'),
(9, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-10 11:35:17');

-- --------------------------------------------------------

--
-- Table structure for table `admin_verification_codes`
--

CREATE TABLE `admin_verification_codes` (
  `id` int(11) NOT NULL,
  `admin_id` int(11) NOT NULL,
  `code` varchar(255) NOT NULL,
  `expires_at` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `is_used` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `admin_verification_codes`
--

INSERT INTO `admin_verification_codes` (`id`, `admin_id`, `code`, `expires_at`, `created_at`, `is_used`) VALUES
(1, 7, '223566', '2025-07-04 22:33:03', '2025-07-04 20:23:03', 0),
(2, 7, '529848', '2025-07-04 22:49:09', '2025-07-04 20:39:09', 0),
(3, 7, '466112', '2025-07-04 23:13:38', '2025-07-04 21:03:38', 0),
(4, 7, '286676', '2025-07-05 08:45:44', '2025-07-05 06:35:44', 0),
(5, 7, '062842', '2025-07-05 10:04:20', '2025-07-05 07:54:20', 0),
(6, 7, '552047', '2025-07-05 10:47:38', '2025-07-05 08:37:38', 0),
(7, 7, '166675', '2025-07-05 16:00:15', '2025-07-05 13:50:15', 1),
(8, 7, '549426', '2025-07-06 19:42:07', '2025-07-06 17:32:07', 0),
(9, 7, '214348', '2025-07-06 20:22:06', '2025-07-06 18:12:06', 0),
(10, 7, '349489', '2025-07-10 12:43:28', '2025-07-10 10:33:28', 0);

-- --------------------------------------------------------

--
-- Table structure for table `banks`
--

CREATE TABLE `banks` (
  `code` varchar(10) NOT NULL,
  `name` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `banks`
--

INSERT INTO `banks` (`code`, `name`) VALUES
('011', 'First Bank of Nigeria'),
('023', 'Citibank Nigeria'),
('030', 'Heritage Bank'),
('032', 'Union Bank of Nigeria'),
('033', 'United Bank for Africa (UBA)'),
('035', 'Zenith Bank'),
('050', 'Ecobank Nigeria'),
('058', 'Guaranty Trust Bank (GTBank)'),
('063', 'Access Bank'),
('070', 'Fidelity Bank'),
('076', 'Polaris Bank'),
('082', 'Keystone Bank'),
('100', 'Suntrust Bank'),
('101', 'Providus Bank'),
('214', 'First City Monument Bank (FCMB)'),
('215', 'Wema Bank'),
('221', 'Stanbic IBTC Bank'),
('232', 'Sterling Bank'),
('301', 'Jaiz Bank'),
('998', 'OPay'),
('999', 'PalmPay');

-- --------------------------------------------------------

--
-- Table structure for table `departments`
--

CREATE TABLE `departments` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `faculty_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `departments`
--

INSERT INTO `departments` (`id`, `name`, `faculty_id`, `created_at`, `updated_at`) VALUES
(1, 'Department of Physics', 1, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(2, 'Department of Chemistry', 1, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(3, 'Department of Mathematics', 1, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(4, 'Department of Biology', 1, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(5, 'Department of English', 2, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(6, 'Department of History', 2, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(7, 'Department of Philosophy', 2, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(8, 'Department of Linguistics', 2, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(9, 'Department of Computer Science', 3, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(10, 'Department of Electrical Engineering', 3, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(11, 'Department of Mechanical Engineering', 3, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(12, 'Department of Civil Engineering', 3, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(13, 'Department of Anatomy', 4, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(14, 'Department of Physiology', 4, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(15, 'Department of Biochemistry', 4, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(16, 'Department of Pharmacology', 4, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(17, 'Department of Commercial Law', 5, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(18, 'Department of Criminal Law', 5, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(19, 'Department of International Law', 5, '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(20, 'Department of Constitutional Law', 5, '2025-06-05 13:39:41', '2025-06-05 13:39:41');

-- --------------------------------------------------------

--
-- Table structure for table `faculties`
--

CREATE TABLE `faculties` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `faculties`
--

INSERT INTO `faculties` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, 'Faculty of Science', '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(2, 'Faculty of Arts', '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(3, 'Faculty of Engineering', '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(4, 'Faculty of Medicine', '2025-06-05 13:39:41', '2025-06-05 13:39:41'),
(5, 'Faculty of Law', '2025-06-05 13:39:41', '2025-06-05 13:39:41');

-- --------------------------------------------------------

--
-- Table structure for table `login_history`
--

CREATE TABLE `login_history` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `device_info` text NOT NULL,
  `login_time` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `login_history`
--

INSERT INTO `login_history` (`id`, `user_id`, `ip_address`, `device_info`, `login_time`) VALUES
(1, 3, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', '2025-06-05 13:34:30'),
(2, 3, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', '2025-06-05 13:52:22'),
(3, 3, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', '2025-06-05 15:25:44'),
(4, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', '2025-06-05 16:37:14'),
(5, 3, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', '2025-06-05 17:43:30'),
(6, 3, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-06-06 01:50:07'),
(7, 3, '::1', 'Mozilla/5.0 (iPhone; CPU iPhone OS 16_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.6 Mobile/15E148 Safari/604.1', '2025-06-07 13:16:30'),
(8, 3, '::1', 'Mozilla/5.0 (iPhone; CPU iPhone OS 16_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.6 Mobile/15E148 Safari/604.1', '2025-06-07 14:52:09'),
(9, 3, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-06-07 19:02:32'),
(10, 3, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-03 14:19:01'),
(11, 3, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-04 06:25:12'),
(12, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-06 18:31:57'),
(13, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-06 18:32:00'),
(14, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-06 18:32:42'),
(15, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-06 18:36:40'),
(16, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-07 16:55:38'),
(17, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-07 16:58:55'),
(18, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-07 18:00:44'),
(19, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-07 18:07:30'),
(20, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-08 13:47:40'),
(21, 3, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-08 13:51:00'),
(22, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-08 22:34:28'),
(23, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-09 06:33:25'),
(24, 6, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-10 01:41:08'),
(25, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-10 10:12:46'),
(26, 7, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', '2025-07-10 10:46:31');

-- --------------------------------------------------------

--
-- Table structure for table `payment_processors`
--

CREATE TABLE `payment_processors` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `processor_type` enum('bank','card','mobile_money') NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `secret_key` varchar(255) DEFAULT NULL,
  `webhook_url` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `students`
--

CREATE TABLE `students` (
  `id` int(11) NOT NULL,
  `student_id` varchar(50) DEFAULT NULL,
  `reg_number` varchar(50) DEFAULT NULL,
  `full_name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `faculty_id` int(11) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `year_of_study` int(11) DEFAULT NULL,
  `gender` enum('Male','Female','Other') DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `verification_code` varchar(100) DEFAULT NULL,
  `verification_code_expiry` datetime DEFAULT NULL,
  `is_verified` tinyint(1) DEFAULT 0,
  `dob` varchar(233) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `reset_token` varchar(255) DEFAULT NULL,
  `reset_expiry` datetime DEFAULT NULL,
  `newsletter_opt_in` tinyint(1) DEFAULT 0,
  `reset_token_expiry` datetime DEFAULT NULL,
  `profile_picture` varchar(255) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `bio` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  `program` varchar(100) DEFAULT NULL,
  `semester` varchar(50) DEFAULT NULL,
  `sms_notifications` tinyint(1) DEFAULT 1,
  `password_changed_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `nationality` varchar(255) NOT NULL,
  `wallet_id` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `students`
--

INSERT INTO `students` (`id`, `student_id`, `reg_number`, `full_name`, `email`, `phone`, `faculty_id`, `department_id`, `year_of_study`, `gender`, `password`, `verification_code`, `verification_code_expiry`, `is_verified`, `dob`, `created_at`, `reset_token`, `reset_expiry`, `newsletter_opt_in`, `reset_token_expiry`, `profile_picture`, `last_login`, `bio`, `address`, `program`, `semester`, `sms_notifications`, `password_changed_at`, `is_active`, `nationality`, `wallet_id`) VALUES
(3, 'NOUNEASY45A0A96E', 'REG202595283', 'OLORODE Micheal seyi', 'holuwaseunisrael@gmail.com', '09028622243', 3, 12, 4, 'Male', '$2y$10$hLE37T.PVJjv1EQ0SZITM.UE2CMq9BZI.QMurNpf5of.GRHR.scle', NULL, NULL, 1, '2000-06-26', '2025-06-02 15:38:29', NULL, NULL, 0, NULL, '../uploads/profile_3_1749130970.jpeg', '2025-07-08 14:51:00', NULL, NULL, 'BSC', '1', 1, '2025-06-05 14:52:01', 1, 'Nigeria', '1'),
(6, 'ATHFEE3CA9B', 'REG202514450', 'Oluwaseunfunmi', 'omsinternational28@gmail.com', '0804567894353', NULL, NULL, NULL, 'Male', '$2y$10$E4xSQlRuqakNu0E2GUF8yOeSmJ1R//AcWjUnD/CYgbWGmVafSi/k6', 'cb29a20e414a4632d4f00051177824bd825e04c38bb16400d6c60db5689cebf8', '2025-06-05 17:15:53', 1, '', '2025-06-04 17:39:11', NULL, NULL, 0, NULL, NULL, '2025-06-05 17:37:14', NULL, NULL, NULL, NULL, 1, NULL, 1, '', '2'),
(7, 'ATH70C4E287', 'REG202571089', 'SEUN', 'olorodemicheal2274@gmail.com', '09028622243', NULL, NULL, NULL, 'Male', '$2y$10$Ge1uV4jxuUECuaNnSjFuQOY/BnZNEC/Q8Rb//JNLkkyIUXoHWtfgG', NULL, NULL, 1, '', '2025-07-04 20:22:40', NULL, NULL, 0, NULL, NULL, '2025-07-10 11:12:46', NULL, NULL, NULL, NULL, 1, NULL, 1, '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `student_bank_accounts`
--

CREATE TABLE `student_bank_accounts` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `bank_name` varchar(100) NOT NULL,
  `bank_code` varchar(20) NOT NULL,
  `account_number` varchar(20) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `is_primary` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `student_bank_accounts`
--

INSERT INTO `student_bank_accounts` (`id`, `student_id`, `bank_name`, `bank_code`, `account_number`, `account_name`, `is_primary`, `created_at`, `updated_at`) VALUES
(8, 3, 'Stanbic IBTC Bank', '221', '0034496467', 'olorode micheal seyi', 1, '2025-06-07 16:58:50', '2025-06-07 16:58:50'),
(9, 7, 'Ecobank Nigeria', '050', '0034496467', 'olorode micheal', 1, '2025-07-10 10:14:03', '2025-07-10 10:14:03');

-- --------------------------------------------------------

--
-- Table structure for table `student_wallets`
--

CREATE TABLE `student_wallets` (
  `id` int(11) NOT NULL,
  `wallet_id` varchar(255) DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `balance` decimal(12,2) DEFAULT 0.00,
  `currency` varchar(3) DEFAULT 'NGN',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `student_wallets`
--

INSERT INTO `student_wallets` (`id`, `wallet_id`, `student_id`, `balance`, `currency`, `created_at`, `updated_at`) VALUES
(1, 'REG202595283', 3, 284656.00, 'NGN', '2025-06-05 17:55:46', '2025-07-04 07:21:11'),
(3, 'REG202571089', 7, 50000.00, 'NGN', '2025-07-08 13:49:59', '2025-07-10 10:13:38');

-- --------------------------------------------------------

--
-- Table structure for table `vendors`
--

CREATE TABLE `vendors` (
  `id` int(11) NOT NULL,
  `vendor_id` varchar(20) NOT NULL,
  `business_name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `business_type` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `tax_id` varchar(50) DEFAULT NULL,
  `contact_person` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `verification_code` varchar(64) DEFAULT NULL,
  `verification_code_expiry` datetime DEFAULT NULL,
  `is_verified` tinyint(1) DEFAULT 0,
  `is_approved` tinyint(1) DEFAULT 0,
  `approved_by` int(11) DEFAULT NULL,
  `approval_date` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `last_login` datetime DEFAULT NULL,
  `profile_picture` varchar(255) DEFAULT 'assets/images/default-avatar.png',
  `withdrawal_pin` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `vendors`
--

INSERT INTO `vendors` (`id`, `vendor_id`, `business_name`, `email`, `phone`, `business_type`, `address`, `tax_id`, `contact_person`, `password`, `verification_code`, `verification_code_expiry`, `is_verified`, `is_approved`, `approved_by`, `approval_date`, `created_at`, `updated_at`, `last_login`, `profile_picture`, `withdrawal_pin`) VALUES
(6, 'VENDE1C61065', 'Baker the vbest', 'olorodemicheal2274@gmail.com', '0902862243', 'FOOD', 'Suite A59, Deplazavile Complex 119 Awolow way, Allen Junction, Ikeja. Lagos', '', 'Olorode Micheal', '$2y$10$88j6dDunlhyK6xcRGzTtjuFihipOMt0XMoAx9/Uo5Sm1iZbs1inH6', NULL, NULL, 1, 1, 7, '2025-07-06 19:12:55', '2025-07-05 15:44:40', '2025-07-10 03:39:38', '2025-07-10 02:41:08', '../uploads/vendor_6_1751989992.jpeg', '$2y$10$FsfJxyWhsUrCytCM7SEqaOa7zBJZ2wP735E3baSvJ0lUPsVhfPF56'),
(7, 'VEND765C4C0D', 'FOOD MART', 'holuwaseunisrael@gmail.com', '', '', '', NULL, 'SEUN FUNMI', '$2y$10$3EIj83t86GeAm0Bz9jvmO.nmsV/J9QKsOE4u1f7xiKgt9dH7titCq', NULL, NULL, 1, 1, 7, '2025-07-10 11:45:04', '2025-07-10 11:28:58', '2025-07-10 11:49:05', '2025-07-10 11:46:31', '../uploads/vendor_7_1752144545.png', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `vendor_bank_accounts`
--

CREATE TABLE `vendor_bank_accounts` (
  `id` int(11) NOT NULL,
  `vendor_id` int(11) DEFAULT NULL,
  `bank_name` varchar(255) NOT NULL,
  `account_name` varchar(255) NOT NULL,
  `account_number` varchar(10) NOT NULL,
  `is_verified` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `vendor_bank_accounts`
--

INSERT INTO `vendor_bank_accounts` (`id`, `vendor_id`, `bank_name`, `account_name`, `account_number`, `is_verified`, `created_at`, `updated_at`) VALUES
(5, 6, 'GTBank', 'olorode micheal', '0034496467', 0, '2025-07-10 09:57:53', '2025-07-10 09:59:38');

-- --------------------------------------------------------

--
-- Table structure for table `vendor_wallets`
--

CREATE TABLE `vendor_wallets` (
  `id` int(11) NOT NULL,
  `vendor_id` varchar(255) NOT NULL,
  `balance` decimal(10,2) NOT NULL DEFAULT 0.00,
  `pending_balance` decimal(10,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `vendor_wallet_transactions`
--

CREATE TABLE `vendor_wallet_transactions` (
  `id` int(11) NOT NULL,
  `vendor_id` varchar(50) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `transaction_type` enum('credit','debit') NOT NULL,
  `reference` varchar(100) NOT NULL,
  `status` enum('pending','completed','failed') DEFAULT 'pending',
  `balance_before` decimal(12,2) NOT NULL,
  `balance_after` decimal(12,2) NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `verification_codes`
--

CREATE TABLE `verification_codes` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `code` varchar(6) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `expires_at` datetime NOT NULL,
  `user_type` varchar(20) NOT NULL,
  `used` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `verification_codes`
--

INSERT INTO `verification_codes` (`id`, `user_id`, `code`, `created_at`, `expires_at`, `user_type`, `used`) VALUES
(1, 3, '854981', '2025-06-05 14:05:16', '2025-06-05 16:15:16', '', 0),
(2, 3, '268453', '2025-06-05 14:08:06', '2025-06-05 16:18:06', '', 0),
(3, 3, '333841', '2025-06-05 14:23:33', '2025-06-05 16:33:33', '', 1),
(4, 3, '665443', '2025-06-05 14:56:06', '2025-06-05 17:06:06', '', 0),
(5, 3, '334500', '2025-06-05 14:56:19', '2025-06-05 17:06:19', '', 0),
(6, 3, '466770', '2025-06-05 15:10:30', '2025-06-05 17:20:30', '', 1),
(7, 3, '255426', '2025-06-05 15:11:53', '2025-06-05 17:21:53', '', 1),
(8, 3, '753968', '2025-06-05 15:15:41', '2025-06-05 17:25:41', '', 0),
(9, 3, '347273', '2025-06-05 15:15:59', '2025-06-05 17:25:59', '', 0),
(10, 3, '599172', '2025-06-05 15:16:20', '2025-06-05 17:26:20', '', 0),
(11, 3, '970571', '2025-06-05 15:16:33', '2025-06-05 17:26:33', '', 0),
(12, 3, '345226', '2025-06-05 15:19:35', '2025-06-05 17:29:34', '', 0),
(13, 3, '649653', '2025-06-05 15:25:05', '2025-06-05 17:35:05', '', 0),
(14, 6, '575880', '2025-06-05 16:36:07', '2025-06-05 18:46:07', '', 0),
(15, 3, '149086', '2025-06-05 17:42:22', '2025-06-05 19:52:22', '', 0),
(16, 3, '790254', '2025-06-06 01:49:17', '2025-06-06 03:59:17', '', 0),
(17, 3, '624341', '2025-06-07 13:15:55', '2025-06-07 15:25:55', '', 0),
(18, 3, '554236', '2025-06-07 14:51:11', '2025-06-07 17:01:11', '', 0),
(19, 3, '866887', '2025-06-07 19:01:59', '2025-06-07 21:11:59', '', 0),
(20, 3, '061327', '2025-07-03 14:18:40', '2025-07-03 16:28:40', '', 0),
(21, 3, '543780', '2025-07-03 18:13:07', '2025-07-03 20:23:07', '', 0),
(22, 3, '361270', '2025-07-04 06:23:10', '2025-07-04 08:33:10', '', 0),
(23, 3, '565574', '2025-07-04 06:24:06', '2025-07-04 08:34:06', '', 0),
(24, 6, '184180', '2025-07-06 18:19:12', '2025-07-06 20:29:12', 'vendor', 0),
(25, 6, '759563', '2025-07-06 18:19:26', '2025-07-06 20:29:26', 'vendor', 0),
(26, 6, '050112', '2025-07-06 18:36:00', '2025-07-06 20:46:00', 'vendor', 0),
(27, 6, '824630', '2025-07-07 16:54:15', '2025-07-07 19:04:15', 'vendor', 0),
(28, 6, '058603', '2025-07-07 16:57:14', '2025-07-07 19:07:14', 'vendor', 0),
(29, 6, '113854', '2025-07-07 17:37:22', '2025-07-07 19:47:22', 'vendor', 0),
(30, 6, '109694', '2025-07-07 18:06:27', '2025-07-07 20:16:27', 'vendor', 0),
(31, 7, '899846', '2025-07-08 13:46:37', '2025-07-08 15:56:37', '', 0),
(32, 3, '907566', '2025-07-08 13:50:25', '2025-07-08 16:00:25', '', 0),
(33, 6, '198622', '2025-07-08 22:31:39', '2025-07-09 00:41:39', 'vendor', 0),
(34, 6, '420840', '2025-07-09 06:31:44', '2025-07-09 08:41:44', 'vendor', 0),
(35, 6, '000087', '2025-07-10 01:40:22', '2025-07-10 03:50:22', 'vendor', 0),
(36, 7, '150251', '2025-07-10 10:10:41', '2025-07-10 12:20:41', '', 0),
(37, 7, '252178', '2025-07-10 10:45:46', '2025-07-10 12:55:46', 'vendor', 0);

-- --------------------------------------------------------

--
-- Table structure for table `wallet_pins`
--

CREATE TABLE `wallet_pins` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `pin_hash` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `wallet_pins`
--

INSERT INTO `wallet_pins` (`id`, `student_id`, `pin_hash`, `created_at`, `updated_at`) VALUES
(1, 3, '$2y$10$zIrV53Fv78I.bVBcobs1uOPBDeLNQiXUNQDb/vU8Meb.2FpHIVDiu', '2025-06-07 16:01:50', '2025-06-07 17:23:58'),
(2, 7, '$2y$10$xPf38Zu8pp74o/ubw5.FpOxq8PP7mimYLSDG7QAbrVDi7dJfcG46K', '2025-07-10 10:13:13', '2025-07-10 10:13:13');

-- --------------------------------------------------------

--
-- Table structure for table `wallet_transactions`
--

CREATE TABLE `wallet_transactions` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `wallet_id` int(11) NOT NULL,
  `bank_account_id` int(11) DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `transaction_type` enum('deposit','withdrawal','transfer','payment') NOT NULL,
  `reference` varchar(100) NOT NULL,
  `status` enum('pending','completed','failed','reversed') DEFAULT 'pending',
  `payment_gateway` varchar(20) DEFAULT NULL,
  `gateway` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`metadata`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `wallet_transactions`
--

INSERT INTO `wallet_transactions` (`id`, `student_id`, `wallet_id`, `bank_account_id`, `amount`, `transaction_type`, `reference`, `status`, `payment_gateway`, `gateway`, `description`, `metadata`, `created_at`) VALUES
(1, 0, 1, NULL, 445.00, 'deposit', 'DEP-6842501FD16CC', 'completed', NULL, NULL, 'Deposit from stanbic ibtc (****6467)', NULL, '2025-06-06 02:19:11'),
(2, 0, 1, NULL, 55.00, 'withdrawal', 'WDR-6842506F2F480', 'completed', NULL, NULL, 'Withdrawal to stanbic ibtc (****6467)', NULL, '2025-06-06 02:20:31'),
(3, 0, 1, NULL, 66.00, 'deposit', 'DEP-6842507C658B0', 'completed', NULL, NULL, 'Deposit from stanbic ibtc (****6467)', NULL, '2025-06-06 02:20:44'),
(4, 3, 1, NULL, 4000.00, '', 'WAL136085604', 'completed', NULL, 'paystack', 'Paystack deposit', NULL, '2025-06-07 20:06:56'),
(5, 3, 1, NULL, 6000.00, '', 'WAL487677845', 'completed', NULL, 'paystack', 'Paystack deposit', NULL, '2025-06-07 20:07:38'),
(6, 0, 1, 8, 1000.00, 'withdrawal', 'WDR17493269163785', 'pending', NULL, NULL, 'Withdrawal to Stanbic IBTC Bank (****6467)', NULL, '2025-06-07 20:08:36'),
(7, 3, 1, NULL, 10000.00, '', 'WAL499114521', 'completed', NULL, 'paystack', 'Paystack deposit', NULL, '2025-06-07 20:32:53'),
(8, 3, 1, NULL, 20000.00, '', 'WAL304421202', 'completed', NULL, 'paystack', 'Paystack deposit', NULL, '2025-06-07 21:46:28'),
(9, 3, 1, NULL, 200.00, '', 'WAL114839108', 'completed', NULL, 'paystack', 'Paystack deposit', NULL, '2025-06-07 21:53:35'),
(10, 3, 1, NULL, 200000.00, '', 'WAL674584673', 'completed', NULL, 'paystack', 'Paystack deposit', NULL, '2025-06-07 21:56:39'),
(11, 0, 1, 8, 10000.00, 'withdrawal', 'WDR17493335021714', 'pending', NULL, NULL, 'Withdrawal to Stanbic IBTC Bank (****6467)', NULL, '2025-06-07 21:58:22'),
(12, 3, 1, NULL, 10000.00, '', 'WAL750713650', 'completed', NULL, 'paystack', 'Wallet deposit', NULL, '2025-06-07 22:10:29'),
(13, 0, 1, 8, 30000.00, 'withdrawal', 'WDR17515523768662', 'pending', NULL, NULL, 'Withdrawal to Stanbic IBTC Bank (****6467)', NULL, '2025-07-03 14:19:36'),
(14, 3, 1, NULL, 5000.00, '', 'WAL518683917', 'completed', NULL, 'paystack', 'Wallet deposit', NULL, '2025-07-04 07:00:31'),
(15, 3, 1, NULL, 70000.00, '', 'WAL1421423', 'completed', NULL, 'paystack', 'Wallet deposit', NULL, '2025-07-04 07:21:11'),
(16, 7, 3, NULL, 50000.00, '', 'WAL288988062', 'completed', NULL, 'paystack', 'Wallet deposit', NULL, '2025-07-10 10:13:38');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `admins`
--
ALTER TABLE `admins`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD UNIQUE KEY `admin_id` (`admin_id`);

--
-- Indexes for table `admin_login_history`
--
ALTER TABLE `admin_login_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `admin_id` (`admin_id`);

--
-- Indexes for table `admin_verification_codes`
--
ALTER TABLE `admin_verification_codes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `admin_id` (`admin_id`);

--
-- Indexes for table `banks`
--
ALTER TABLE `banks`
  ADD PRIMARY KEY (`code`);

--
-- Indexes for table `departments`
--
ALTER TABLE `departments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `faculty_id` (`faculty_id`);

--
-- Indexes for table `faculties`
--
ALTER TABLE `faculties`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `login_history`
--
ALTER TABLE `login_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `payment_processors`
--
ALTER TABLE `payment_processors`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `students`
--
ALTER TABLE `students`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD UNIQUE KEY `student_id` (`student_id`),
  ADD UNIQUE KEY `reg_number` (`reg_number`);

--
-- Indexes for table `student_bank_accounts`
--
ALTER TABLE `student_bank_accounts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `student_wallets`
--
ALTER TABLE `student_wallets`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `student_id` (`student_id`);

--
-- Indexes for table `vendors`
--
ALTER TABLE `vendors`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `vendor_id` (`vendor_id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `email_2` (`email`),
  ADD KEY `vendor_id_2` (`vendor_id`),
  ADD KEY `is_approved` (`is_approved`);

--
-- Indexes for table `vendor_bank_accounts`
--
ALTER TABLE `vendor_bank_accounts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `vendor_id` (`vendor_id`,`account_number`);

--
-- Indexes for table `vendor_wallets`
--
ALTER TABLE `vendor_wallets`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `vendor_id` (`vendor_id`);

--
-- Indexes for table `vendor_wallet_transactions`
--
ALTER TABLE `vendor_wallet_transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `vendor_id` (`vendor_id`);

--
-- Indexes for table `verification_codes`
--
ALTER TABLE `verification_codes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `wallet_pins`
--
ALTER TABLE `wallet_pins`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `wallet_transactions`
--
ALTER TABLE `wallet_transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `wallet_id` (`wallet_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `admins`
--
ALTER TABLE `admins`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `admin_login_history`
--
ALTER TABLE `admin_login_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `admin_verification_codes`
--
ALTER TABLE `admin_verification_codes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `departments`
--
ALTER TABLE `departments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=21;

--
-- AUTO_INCREMENT for table `faculties`
--
ALTER TABLE `faculties`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `login_history`
--
ALTER TABLE `login_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=27;

--
-- AUTO_INCREMENT for table `payment_processors`
--
ALTER TABLE `payment_processors`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `students`
--
ALTER TABLE `students`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `student_bank_accounts`
--
ALTER TABLE `student_bank_accounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `student_wallets`
--
ALTER TABLE `student_wallets`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `vendors`
--
ALTER TABLE `vendors`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `vendor_bank_accounts`
--
ALTER TABLE `vendor_bank_accounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `vendor_wallets`
--
ALTER TABLE `vendor_wallets`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vendor_wallet_transactions`
--
ALTER TABLE `vendor_wallet_transactions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `verification_codes`
--
ALTER TABLE `verification_codes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=38;

--
-- AUTO_INCREMENT for table `wallet_pins`
--
ALTER TABLE `wallet_pins`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `wallet_transactions`
--
ALTER TABLE `wallet_transactions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `admin_login_history`
--
ALTER TABLE `admin_login_history`
  ADD CONSTRAINT `admin_login_history_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `admin_verification_codes`
--
ALTER TABLE `admin_verification_codes`
  ADD CONSTRAINT `admin_verification_codes_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `departments`
--
ALTER TABLE `departments`
  ADD CONSTRAINT `departments_ibfk_1` FOREIGN KEY (`faculty_id`) REFERENCES `faculties` (`id`);

--
-- Constraints for table `login_history`
--
ALTER TABLE `login_history`
  ADD CONSTRAINT `login_history_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `students` (`id`);

--
-- Constraints for table `student_bank_accounts`
--
ALTER TABLE `student_bank_accounts`
  ADD CONSTRAINT `student_bank_accounts_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `student_wallets`
--
ALTER TABLE `student_wallets`
  ADD CONSTRAINT `student_wallets_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`);

--
-- Constraints for table `vendor_bank_accounts`
--
ALTER TABLE `vendor_bank_accounts`
  ADD CONSTRAINT `vendor_bank_accounts_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `vendor_wallet_transactions`
--
ALTER TABLE `vendor_wallet_transactions`
  ADD CONSTRAINT `vendor_wallet_transactions_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`vendor_id`);

--
-- Constraints for table `verification_codes`
--
ALTER TABLE `verification_codes`
  ADD CONSTRAINT `verification_codes_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `wallet_pins`
--
ALTER TABLE `wallet_pins`
  ADD CONSTRAINT `wallet_pins_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `wallet_transactions`
--
ALTER TABLE `wallet_transactions`
  ADD CONSTRAINT `wallet_transactions_ibfk_1` FOREIGN KEY (`wallet_id`) REFERENCES `student_wallets` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
